function [expr,cellid]=makeexprmat3d(genes,Lnew,rol)
%assign rolonies to cells to make expression matrix. This version uses
%basecalled rolony identities that were previously produced
%   genes: rolony gene identity called previously
%   Lnew: cell positions and ids generated by findnuclei.
%   rol: rolony positions (Without nricp) generated by seqfindroloniesij
%   rolidx: the indices of matching rolonies genreated by nricpbasecall

%convert sequences to gene tags

%assign rolonies to cells.
cellidx=zeros(length(genes),1);

for i=1:length(genes)
    cellidx(i)=Lnew(rol(i,1),rol(i,2));
end
%remove rolonies with no cells and cells with no rolonies
i=(cellidx>0)&(genes>0);
cellidx(~i)=[];
genes(~i)=[];

cellid=unique(cellidx);%cell to Lnew lookup
[~,c]=ismember(cellidx,unique(cellidx));
expr=zeros(length(cellid),max(genes));
lidx=sub2ind(size(expr),c,genes);
for i=1:length(lidx)
    expr(lidx(i))=expr(lidx(i))+1;
end

save('expr.mat','expr','cellid');